IF EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[V_EST_GRP_COMIS_DESC]'))
	DROP VIEW [dbo].[V_EST_GRP_COMIS_DESC]

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE VIEW [dbo].[V_EST_GRP_COMIS_DESC] AS

SELECT
	vinc.CD_EMP
	,vinc.CD_CLASS_COMIS_DESC
	,vinc.CD_GRP_COMIS
	,grp_prod.CD_PROD
	,vinc_fil.CD_FILIAL
	,vinc_fun.CD_FUN
	,vinc.DESC_INI
	,vinc.DESC_FIM
	,vinc.PERC_COMIS_DESC
	,grp_prod.QTDE_INI
	,grp_prod.QTDE_FINAL
	,grp_prod.QTDE_ANULA 
FROM
	EST_GRP_COMIS_CLASS_DESC_EST_GRP_COMIS vinc
	INNER JOIN EST_GRP_COMIS grp ON
		vinc.CD_EMP = grp.CD_EMP AND
		vinc.CD_GRP_COMIS = grp.CD_GRP_COMIS
	INNER JOIN EST_GRP_COMIS_EST_PROD grp_prod ON
		grp.CD_EMP = grp_prod.CD_EMP AND
		grp.CD_GRP_COMIS = grp_prod.CD_GRP_COMIS
	INNER JOIN EST_GRP_COMIS_CLASS_DESC_PRC_FILIAL vinc_fil ON
		vinc.CD_EMP = vinc_fil.CD_EMP AND
		vinc.CD_CLASS_COMIS_DESC = vinc_fil.CD_CLASS_COMIS_DESC
	INNER JOIN EST_GRP_COMIS_CLASS_DESC_FP_FUNC vinc_fun ON
		vinc.CD_EMP = vinc_fun.CD_EMP AND
		vinc.CD_CLASS_COMIS_DESC = vinc_fun.CD_CLASS_COMIS_DESC
UNION
SELECT
	vinc.CD_EMP
	,vinc.CD_CLASS_COMIS_DESC
	,vinc.CD_GRP_COMIS
	,prod.CD_PROD
	,vinc_fil.CD_FILIAL
	,vinc_fun.CD_FUN
	,vinc.DESC_INI
	,vinc.DESC_FIM
	,vinc.PERC_COMIS_DESC
	,grp_linha.QTDE_INI
	,grp_linha.QTDE_FINAL
	,grp_linha.QTDE_ANULA
FROM
	EST_GRP_COMIS_CLASS_DESC_EST_GRP_COMIS vinc
	INNER JOIN EST_GRP_COMIS grp ON
		vinc.CD_EMP = grp.CD_EMP AND
		vinc.CD_GRP_COMIS = grp.CD_GRP_COMIS
	INNER JOIN EST_GRP_COMIS_EST_ARV_MERC_LINHA grp_linha ON
		grp.CD_EMP = grp_linha.CD_EMP AND
		grp.CD_GRP_COMIS = grp_linha.CD_GRP_COMIS
	INNER JOIN EST_PROD_EST_ARV_MERCADOLOGICA arv ON
		grp_linha.CD_EMP = arv.CD_EMP AND
		grp_linha.CD_ARV_MERC_LINHA = arv.CD_ARV_MERC_LINHA
	INNER JOIN EST_PROD prod ON
		arv.CD_EMP = prod.CD_EMP AND
		arv.CD_PROD = prod.CD_PROD AND
		prod.STS_PROD in(0,2)
	INNER JOIN EST_GRP_COMIS_CLASS_DESC_PRC_FILIAL vinc_fil ON
		vinc.CD_EMP = vinc_fil.CD_EMP AND
		vinc.CD_CLASS_COMIS_DESC = vinc_fil.CD_CLASS_COMIS_DESC
	INNER JOIN EST_GRP_COMIS_CLASS_DESC_FP_FUNC vinc_fun ON
		vinc.CD_EMP = vinc_fun.CD_EMP AND
		vinc.CD_CLASS_COMIS_DESC = vinc_fun.CD_CLASS_COMIS_DESC
WHERE
	NOT EXISTS(SELECT  grp_prod.CD_PROD
				FROM
					EST_GRP_COMIS_CLASS_DESC_EST_GRP_COMIS vinc_i
					INNER JOIN EST_GRP_COMIS grp ON
						vinc_i.CD_EMP = grp.CD_EMP AND
						vinc_i.CD_GRP_COMIS = grp.CD_GRP_COMIS
					INNER JOIN EST_GRP_COMIS_EST_PROD grp_prod ON
						grp.CD_EMP = grp_prod.CD_EMP AND
						grp.CD_GRP_COMIS = grp_prod.CD_GRP_COMIS
					INNER JOIN EST_GRP_COMIS_CLASS_DESC_PRC_FILIAL vinc_fil ON
						vinc_i.CD_EMP = vinc_fil.CD_EMP AND
						vinc_i.CD_CLASS_COMIS_DESC = vinc_fil.CD_CLASS_COMIS_DESC
					INNER JOIN EST_GRP_COMIS_CLASS_DESC_FP_FUNC vinc_fun ON
						vinc_i.CD_EMP = vinc_fun.CD_EMP AND
						vinc_i.CD_CLASS_COMIS_DESC = vinc_fun.CD_CLASS_COMIS_DESC
				WHERE
				prod.CD_EMP                = grp_prod.CD_EMP AND
				prod.CD_PROD               = grp_prod.CD_PROD AND
				vinc_i.CD_CLASS_COMIS_DESC = vinc.CD_CLASS_COMIS_DESC) 

GO 
